;****************************************************************************************************************************************************
;****************************************************************************************************************************************************
;------------------------------------------------------------Configuration du microcontrolleur------------------------------------------------------
;****************************************************************************************************************************************************
;****************************************************************************************************************************************************
                                 LIST   p=16F84A           ; definire le pic utilis
                                 #include <p16F84A.inc>    ; directive du fichier source

                __CONFIG   _CP_OFF & _WDT_OFF & _HS_OSC & _PWRTE_ON

;***************************************************************************************************************************************************

;****************************************************************************************************************************************************
;****************************************************************************************************************************************************
;-----------------------------------------------------------------Declaration des variables----------------------------------------------------------
;****************************************************************************************************************************************************

 CBLOCK       0x0C               ; adress du debut de la zone (variables)
              COMP1 : 1          ; variable de 1 octet soit 8 bits
              COMP2 : 1          ; variable de 1 octet soit 8 bits
              COMP3 : 1          ; variable de 1 octet soit 8 bits
                C1  : 1          ;
              INT1  : 1          ;
              ENDC               ; fin de la zone (variables)

;****************************************************************************************************************************************************


;****************************************************************************************************************************************************
;****************************************************************************************************************************************************
;---------------------------------------------------------------Initialisation du Microcontrolleur--------------------------------------------------
;****************************************************************************************************************************************************
;****************************************************************************************************************************************************

              org         0x000    ; adresse de debut du programme apres le demarrage ou reset
              goto        main     ; aller vers l'adress (main)

;***************************************************************************************************************************************************


;****************************************************************************************************************************************************
;--------------------------------------------------------------Sous programmes tempos--------------------------------------------------------------
;****************************************************************************************************************************************************
SEC2
         movlw          d'167'   ;
         movwf          COMP3    ;
    rep41
         movlw          d'164'   ;
         movwf          COMP2    ;
    rep51
         movlw          d'23'    ;
         movwf          COMP1    ;
    rep61
         decfsz         COMP1,f  ;
         goto           rep61    ;
         decfsz         COMP2,f  ;
         goto           rep51    ;
         decfsz         COMP3,f  ;
         goto           rep41    ;

         return 



MS2
         movlw          d'21'    ;
         movwf          COMP3    ;
    rep4
         movlw          d'13'    ;
         movwf          COMP2    ;
    rep5
         movlw          d'1'     ;
         movwf          COMP1    ;
    rep6
         decfsz         COMP1,f  ;
         goto           rep6     ;
         decfsz         COMP2,f  ;
         goto           rep5     ;
         decfsz         COMP3,f  ;
         goto           rep4     ;

         return 




MICS40
         movlw          d'20'  ;
         movwf          C1     ;
OTI
         decfsz         C1,f   ;
         goto           OTI    ;
   
         return 



LCD_E
         bsf             PORTA,1 ;
         nop                     ;
         call            MICS40  ;
         nop                     ;
         bcf             PORTA,1 ;
      
         return


;****************************************************************************************************************************************************

;****************************************************************************************************************************************************
;****************************************************************************************************************************************************
;--------------------------------------------------------------Configuration des ports A/B-----------------------------------------------------------
;****************************************************************************************************************************************************
;****************************************************************************************************************************************************

               main
                     bsf              STATUS,RP0         ; 
                     bcf              STATUS,RP1         ;
                                                         ; ouvrir la banque 

                     movlw            b'00001100'        ; charger le work avec la valeur h'CF'
                     movwf            TRISA              ; mettre le contenu du work dans TRISA
                     movlw            h'00'              ; charger le work avec la valeur h'80'
                     movwf            TRISB              ; mettre le contenu du work dans TRISB
                     bcf              STATUS,RP0         ; 
                     bcf              STATUS,RP1         ;
                                                         ; retour a la banque 0

;****************************************************************************************************************************************************




;****************************************************************************************************************************************************
;****************************************************************************************************************************************************
;---------------------------------------------------------------Debut du programme initial-----------------------------------------------------------
;****************************************************************************************************************************************************
;****************************************************************************************************************************************************
           
                   
                     clrf             PORTA              ;
                     clrf             PORTB              ;
                     call             SEC2               ;

                     movlw             d'5'              ;
                     movwf             INT1              ;
REPT
                     movlw             h'33'             ;                         
                     movwf             PORTB             ;
                     call              LCD_E             ;
                     decfsz            INT1,f            ;
                     goto              REPT              ;

                     

                     movlw             h'3B'             ; ECRIRE B
                     movwf             PORTB             ;
                     call              LCD_E             ;
 
                     movlw             h'0C'             ; ERCIRE A
                     movwf             PORTB             ;
                     call              LCD_E             ;

                     movlw             h'06'             ; ECRIRE D
                     movwf             PORTB             ;
                     call              LCD_E             ;

                     movlw             h'01'             ; ECRIRE R
                     movwf             PORTB             ;
                     call              LCD_E             ;
                     call              MS2               ;
                     goto              EWX2              ;


EWX2            
                      btfsc             PORTA,2          ;
                      goto              EWX1             ;
                      bsf               PORTA,0          ;
                      movlw             h'42'
                      movwf             PORTB            ;
                      call              LCD_E            ;
                      movlw             h'41'            ;
                      movwf             PORTB            ;
                      call              LCD_E            ;
                      movlw             h'44'            ;
                      movwf             PORTB            ;
                      call              LCD_E            ;
                      movlw             h'52'            ;
                      movwf             PORTB            ;
                      call              LCD_E            ;
                      goto              EWX2             ;
EWX1
                      btfsc             PORTA,3          ;
                      goto              EWX2             ;
                      bcf               PORTA,0          ;
                      movlw             h'01'            ;
                      movwf             PORTB            ;
                      call              LCD_E            ;
                      call              SEC2             ;
                      goto              EWX2             ;
    
END                                                      ; END LCD DIRECTIVE




















